<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Content-Type: application/json');

// Preflight CORS
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require 'my_family_db.php'; // $conn adalah PDO

try {
    // Ambil input; ubah '' -> null untuk kolom opsional int
    $name      = isset($_POST['name']) ? trim($_POST['name']) : '';
    $gender    = isset($_POST['gender']) ? trim($_POST['gender']) : '';
    $parent_id = isset($_POST['parent_id']) && $_POST['parent_id'] !== '' ? (int)$_POST['parent_id'] : null;
    $spouse_id = isset($_POST['spouse_id']) && $_POST['spouse_id'] !== '' ? (int)$_POST['spouse_id'] : null;
    $family_id = isset($_POST['family_id']) ? (int)$_POST['family_id'] : 0;

    // Validasi sederhana
    if ($name === '' || $gender === '' || $family_id === 0) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'name, gender, dan family_id wajib diisi']);
        exit;
    }

    // Insert (PDO)
    $sql = "INSERT INTO family_members (name, gender, parent_id, spouse_id, family_id)
            VALUES (:name, :gender, :parent_id, :spouse_id, :family_id)";
    $stmt = $conn->prepare($sql);
    $ok = $stmt->execute([
        ':name'       => $name,
        ':gender'     => $gender,     // 'M' atau 'F'
        ':parent_id'  => $parent_id,  // bisa NULL
        ':spouse_id'  => $spouse_id,  // bisa NULL
        ':family_id'  => $family_id
    ]);

    if ($ok) {
        echo json_encode([
            'status' => 'success',
            'insert_id' => $conn->lastInsertId()
        ]);
    } else {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'Insert gagal']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}