<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

require_once 'my_family_db.php';

// Cek apakah form dikirim via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';

    // Upload foto ayah
    $fatherPhotoName = '';
    if (isset($_FILES['father_photo']) && $_FILES['father_photo']['error'] === UPLOAD_ERR_OK) {
        $fatherPhotoName = 'all_father_' . basename($_FILES['father_photo']['name']);
        move_uploaded_file($_FILES['father_photo']['tmp_name'], 'uploads/' . $fatherPhotoName);
    }

    // Upload foto ibu
    $motherPhotoName = '';
    if (isset($_FILES['mother_photo']) && $_FILES['mother_photo']['error'] === UPLOAD_ERR_OK) {
        $motherPhotoName = 'all_mother_' . basename($_FILES['mother_photo']['name']);
        move_uploaded_file($_FILES['mother_photo']['tmp_name'], 'uploads/' . $motherPhotoName);
    }

    try {
        $stmt = $conn->prepare("INSERT INTO family (name, father_photo, mother_photo) VALUES (:name, :father, :mother)");
        $stmt->execute([
            ':name' => $name,
            ':father' => $fatherPhotoName,
            ':mother' => $motherPhotoName
        ]);

        echo json_encode(["status" => "success", "message" => "Keluarga berhasil ditambahkan."]);
    } catch (PDOException $e) {
        echo json_encode(["status" => "error", "message" => $e->getMessage()]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request."]);
}